Transitioning to a New Upstream Version in a Nutshell
=====================================================

When upstream releases a new version, we should follow these steps:

### Merging new upstream tag (`zsh-$version`) into our upstream branch

    % git checkout upstream
    % git pull --ff-only origin
    % git fetch zsh
    % git merge --ff-only zsh-$version

### Merging the branch upstream into the branch debian

Merge `upstream` into `debian`:

    % git checkout debian
    % git merge upstream

Make the commit message something like:

    New upstream release candidate 5.6.2-test-2
    
    Merge branch 'upstream' at 'zsh-5.6.2-test-2' into branch debian

### Create a debian/changelog entry for the new upstream release

Use `gbp dch` as a base and then remove all lines which are not
debian-specific and which do not relate to a Debian bug report. Add
Debian bug report references (`Closes: #nnnnnn`) as necessary.

Use the tagged upstream commit and the merge commit where the upstream
release was merged into the debian branch as referred commit ids.

Example:

    * [9dbde9e,bf8b7f7] New upstream release candidate
      + [dc2bfeee] Have V07pcre fail if PCRE was enabled by configure
        (config.modules) but failed to load for any reason. (Closes: #909114)

    [ Axel Beckert ]
    * [abcd1234] Some debian-specific change generated by gbp dch from
      the git commit message.
      
Commit it as follows:

    % git add debian/changelog
    % git commit -m "Update debian/changelog for new upstream release" -m "Gbp-Dch: Ignore"

### Remove all quilt patches which are applied upstream

All patches applied (or fixed otherwise) upstream should be removed
from `debian/patches` directory and the `debian/patches/series` file.

Example:

    % quilt push -a
    % quilt pop -a
    % git rm debian/patchees/cherry*
    % $EDITOR debian/patches/series
    % git add debian/patches
    % quilt push -a
    % quilt pop -a
    % git commit -m "Remove all patches applied upstream"

### Create the fake orig tar ball (until we can work with upstream's tarball)

This requires the upstream release to be properly tagged.

    % make -f debian/rules get-orig-source
