(**
    Demo for VisualOberon. Demonstrates the table object.
**)

MODULE TestTable;

(*
    Demo for VisualOberon. Demonstrates the table object.
    Copyright (C) 1998  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VODisplay,
       G   := VOGUIObject,
       K   := VOKeyHandler,
       P   := VOPanel,
       T   := VOTable,
       TM  := VOTableModel,
              VOUsePrefs,
       W   := VOWindow,

              Err;

VAR
  d          : D.Display;
  w          : W.Window;
  keyHandler : K.KeyHandler;

  panel      : P.Panel;
  table      : T.Table;
  model1     : TM.TestTable;
  model2     : TM.ASTableModel;

  msg2Exit   : D.Msg2Exit;

BEGIN
  NEW(d);
  IF ~d.InitDisplay("Table") THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(keyHandler);
  keyHandler.Init;

  NEW(panel);
  panel.Init;
  panel.Set(P.horizontal);
  panel.SetFlags({G.horizontalFlex,G.verticalFlex});

    NEW(model1);
    model1.Init;

    NEW(table);
    table.Init;
    table.SetFlags({G.horizontalFlex,G.verticalFlex});
    table.SetWidth(G.sizeFontRel,50);
    table.SetHeight(G.sizeFontRel,50);
    table.SetModel(model1);
    table.SetSelectionType(T.cellSelect);
    keyHandler.AddFocusObject(table);
  panel.Add(table);

    NEW(model2);
    model2.Init;
    model2.SetSize(2,2);
    model2.SetColumnString(1,"\ebTestcolumn\en\n\esone");
    model2.SetColumnString(2,"\ebTestcolumn\en\n\estwo");
    model2.SetString(1,1,"(1,1)");
    model2.SetString(2,1,"(2,1)");
    model2.SetString(1,2,"(1,2)");
    model2.SetString(2,2,"(2,2)");

    NEW(table);
    table.Init;
    table.SetFlags({G.horizontalFlex,G.verticalFlex});
    table.SetWidth(G.sizeFontRel,50);
    table.SetHeight(G.sizeFontRel,50);
    table.SetModel(model2);
    table.SetSelectionType(T.singleLineSelect);
    keyHandler.AddFocusObject(table);
  panel.Add(table);

  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(panel);
  w.SetTitle("Table");
  w.AddKeyHandler(keyHandler);
  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;

  d.Handler;

  d.Deinit;
END TestTable.