/*
 * Copyright 1999, TaBE Project, All Rights Reserved.
 * Copyright 1999, Pai-Hsiang Hsiao, All Rights Reserved.
 *
 * $Id: tsiadd.c,v 1.3 2000/06/28 06:41:20 thhsieh Exp $
 *
 */
#ifdef HAVE_CONFIG_H
#include "../../config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <db.h>
#include <tabe.h>

#define BUF_SIZE 1000

void
usage(void)
{
  printf("Usage: tsiadd -d <TsiDB> [-f input file -r -y]\n");
  printf("   -d <TsiDB>     \t path to TsiDB\n");
  printf("   -f <input file>\t input file in plain text (default: stdin)\n");
  printf("   -r             \t incorporate reference count (default: not)\n");
  printf("   -y             \t incorporate yin data (default: not)\n");
  exit(0);
}

void
archive(struct TsiDB *db, FILE *fp, int ref, int tsiyin)
{
  struct TsiInfo *tsi;
  int rval, i, j, l, m, n, len;
  unsigned char buf[BUF_SIZE], yin[BUF_SIZE], tmpyin[20], *p, *q;
  unsigned long int refcount;

  rval = db->RecordNumber(db);
  if (rval < 0) {
    fprintf(stderr, "tsiadd: wrong DB format.\n");
    usage();
  }

  tsi = (struct TsiInfo *)malloc(sizeof(struct TsiInfo));
  tsi->tsi = (ZhiStr)malloc(sizeof(unsigned char)*80);
  memset(tsi->tsi, 0, 80);
  tsi->refcount = 0;
  tsi->yinnum = 0;
  tsi->yindata = (Yin *)NULL;

  memset(buf, 0, BUF_SIZE);
  memset(yin, 0, BUF_SIZE);

  i = j = 0;
  while (1) {
    if (!fgets((char *)buf, BUF_SIZE-1, fp)) {
      break;
    }
    i++;
    yin[0] = (unsigned char)NULL;
    if (!ref) {
      buf[strlen((char *)buf)-1] = (unsigned char)NULL;
      strcpy((char *)tsi->tsi, (char *)buf);
    }
    else {
      sscanf((char *)buf, "%20s %ld %s\n", 
	     (char *)tsi->tsi, &refcount, (char *)yin);
      tsi->refcount = refcount;
    }
    len = strlen((char *)tsi->tsi)/2;
    if (strlen((char *)yin)) {
      l = 0;
      p = yin;
      while ((p = (unsigned char *)strstr((char *)p, "@"))) {
        p++;
        l++;
      }
      tsi->yinnum = (l+1)/len;
      tsi->yindata = (Yin *)realloc(tsi->yindata, sizeof(Yin)*(l+1));
      p = yin;
      for (m = 0; m < tsi->yinnum; m++) {
        for (n = 0; n < len; n++) {
           q = (unsigned char *)strstr((char *)p, "@");
           if (q) {
             strncpy((char *)tmpyin, (char *)p, q-p);
             tmpyin[q-p] = (unsigned char)NULL;
             tsi->yindata[m*len+n] = tabeZuYinSymbolSequenceToYin(tmpyin);
             p = q+2;
           }
           else {
             strncpy((char *)tmpyin, (char *)p, strlen((char *)p));
             tmpyin[strlen((char *)p)] = (unsigned char)NULL;
             tsi->yindata[m*len+n] = tabeZuYinSymbolSequenceToYin(tmpyin);
             break;
           }
        }
      }
    }
    else {
      tabeTsiInfoLookupPossibleTsiYin(tsi);
      if (tsi->yinnum > 1) {
        tsi->yinnum = 0;
        free(tsi->yindata);
        tsi->yindata = NULL;
      }
    }
    db->flags |= DB_FLAG_OVERWRITE;
    rval = db->Put(db, tsi);
    db->flags ^= DB_FLAG_OVERWRITE;
    if (!rval) {
      j++;
    }
    if (tsi->yinnum) {
      free(tsi->yindata);
      tsi->yindata = NULL;
    }
  }

  printf("There're %d queries, %d added.\n", i, j);
  db->Close(db);
}

int
main(int argc, char **argv)
{
  int ch;
  int ref, tsiyin;
  FILE *fp;
  struct TsiDB *db;
extern char *optarg;
extern int optind, opterr, optopt;

  char *db_name, *op_name;

  db_name = op_name = (char *)NULL;
  ref = 0;
  tsiyin = 0;

  while ((ch = getopt(argc, argv, "d:f:ry")) != -1) {
    switch(ch) {
      case 'd':
        db_name = (char *)strdup(optarg);
        break;
      case 'f':
        op_name = (char *)strdup(optarg);
        break;
      case 'r':
        ref = 1;
        break;
      case 'y':
        tsiyin = 1;
        break;
      default:
        usage();
        break;
    }
  }
  argc -= optind;
  argv += optind;

  if (!db_name) {
    usage();
  }

  db = tabeTsiDBOpen(DB_TYPE_DB, db_name, DB_FLAG_CREATEDB);
  if (!db) {
    usage();
  }

  if (op_name) {
    fp = fopen(op_name, "r");
    archive(db, fp, ref, tsiyin);
    fclose(fp);
  }
  else {
    archive(db, stdin, ref, tsiyin);
  }

  return(0);
}
