#!/bin/bash
# $Id: check_pg.sh,v 1.1 1999/11/27 21:41:00 mag Exp $

PMINIT=/etc/postgresql/postmaster.init

chk_manually()
{
	echo "Check Postgres' config whether accepts TCP/IP connections"
	echo "  Either postmaster gets the -i flag or"
	echo "  postmaster.init (in /etc/postgresql/ or whatever)"
	echo "    contains PGALLOWTCPIP=yes (uncommented)"
}

if [ -f $PMINIT ]
then
	TCPOK=`grep "^PGALLOWTCPIP=yes" $PMINIT`
	PORTOK=`grep "^PGPORT=" $PMINIT`
	if [ -z "$TCPOK" -o -z $PORTOK ]
	then
		chk_manually
	fi
else
	chk_manually
fi

