#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "wmppxp-x.h"

#include "./wmppxp.xpm"
#include "./wmppxp-parts.xpm"
#include "./wmppxp-mask.xbm"

/* X-Window variables */
int        screen;
Window     Root;
Window     window;
Window     iconwin;
XSizeHints sizeHints;
XWMHints   wmHints;
char       *Geometry = "";
GC         xgc;
XpmIcon    wmppxpIcon;
XpmIcon    wmppxpParts;
Pixmap     pixmask;

void CreateXWindow( int argc, char *argv[] )
{
  int borderWidth = 1;
  int gravity = 0;
  char *displayName = NULL;
  char *windowName = "wmppxp";

  XClassHint classHint;
  XTextProperty textProp;
  XGCValues gcValues;
  unsigned long gcMask;

  if( !( display = XOpenDisplay( displayName ) ) )
  {
    fprintf( stderr, "Can't open display: %s\n", XDisplayName( displayName ) );
    exit( 1 );
  }

  screen = DefaultScreen( display );
  Root = RootWindow( display, screen );
 
  CreateImageFromPixmap();
 
  sizeHints.flags = USSize | USPosition;
  sizeHints.x = 0;
  sizeHints.y = 0;

  XWMGeometry( display, screen, Geometry, NULL, borderWidth, &sizeHints,
               &sizeHints.x, &sizeHints.y, &sizeHints.width, &sizeHints.height,
               &gravity );

  sizeHints.width = 64;
  sizeHints.height = 64;

  window = XCreateSimpleWindow( display, Root, sizeHints.x, sizeHints.y,
                                sizeHints.width, sizeHints.height, borderWidth,
                                BlackPixel( display, 0 ),
                                WhitePixel( display, 0 ) );
  iconwin = XCreateSimpleWindow( display, window, sizeHints.x, sizeHints.y,
                                 sizeHints.width, sizeHints.height,
                                 borderWidth,
                                 BlackPixel( display, 0 ),
                                 WhitePixel( display, 0 ) );

  XSetWMNormalHints( display, window, &sizeHints );
  classHint.res_name = NAME;
  classHint.res_class = CLASS;
  XSetClassHint( display, window, &classHint );

  XSelectInput( display, window,
                ButtonPressMask | ButtonReleaseMask | PointerMotionMask |
                ExposureMask | StructureNotifyMask );
  XSelectInput( display, iconwin,
                ButtonPressMask | ButtonReleaseMask | PointerMotionMask |
                ExposureMask | StructureNotifyMask );

  if( XStringListToTextProperty( &windowName, 1, &textProp ) == 0 )
  {
    fprintf( stderr, "%s: can't allocate window name\n", windowName );
    exit( 1 );
  }

  XSetWMName( display, window, &textProp );

  /* Create GC for drawing */
  gcMask = GCForeground | GCBackground | GCGraphicsExposures;
  gcValues.foreground = BlackPixel( display, 0 );
  gcValues.background = WhitePixel( display, 0 );
  gcValues.graphics_exposures = 0;
  xgc = XCreateGC( display, Root, gcMask, &gcValues );

  pixmask = XCreateBitmapFromData( display, window, wmppxp_mask_bits,
                                   wmppxp_mask_width, wmppxp_mask_height );
  XShapeCombineMask( display, window, ShapeBounding, 0, 0, pixmask, ShapeSet );
  XShapeCombineMask( display, iconwin, ShapeBounding, 0, 0, pixmask, ShapeSet );

  wmHints.initial_state = WithdrawnState;
  wmHints.icon_window = iconwin;
  wmHints.icon_x = sizeHints.x;
  wmHints.icon_y = sizeHints.y;
  wmHints.window_group = window;
  wmHints.flags = StateHint | IconWindowHint | IconPositionHint |
                  WindowGroupHint;

  XSetWMHints( display, window, &wmHints );
  XSetCommand( display, window, argv, argc );
  XMapWindow( display, window );
}

void RedrawWindow()
{
  XEvent event;
  int i = 0;

  while( XCheckTypedWindowEvent( display, iconwin, Expose, &event ) )
  {
    i++;
  }
  XCopyArea( display, wmppxpIcon.pixmap, iconwin, xgc,
             0, 0, wmppxpIcon.attr.width, wmppxpIcon.attr.height, 0, 0 );
  if( IsConnect )
  {
    ShowXpm( BTN_CON_ON_X, BTN_CON_ON_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
	     rgnCon.left, rgnCon.top );
    ShowXpm( CON_X, CON_Y, CON_WIDTH, CON_HEIGHT, 40, 50 );
  }

  while( XCheckTypedWindowEvent( display, window, Expose, &event ) )
  {
    i++;
  }
  XCopyArea( display, wmppxpIcon.pixmap, window, xgc,
             0, 0, wmppxpIcon.attr.width, wmppxpIcon.attr.height, 0, 0 );
}

void RedrawInMeter()
{
  XEvent event;
  int i = 0;

  while( XCheckTypedWindowEvent( display, iconwin, Expose, &event ) )
  {
    i++;
  }
  XCopyArea( display, wmppxpIcon.pixmap, iconwin, xgc,
             11, 30, 46, 5, 11, 30 );

  while( XCheckTypedWindowEvent( display, iconwin, Expose, &event ) )
  {
    i++;
  }
  XCopyArea( display, wmppxpIcon.pixmap, window, xgc,
             11, 30, 46, 5, 11, 30 );  
}

void RedrawOutMeter()
{
  XEvent event;
  int i = 0;

  while( XCheckTypedWindowEvent( display, iconwin, Expose, &event ) )
  {
    i++;
  }
  XCopyArea( display, wmppxpIcon.pixmap, iconwin, xgc,
             11, 36, 46, 5, 11, 36 );

  while( XCheckTypedWindowEvent( display, iconwin, Expose, &event ) )
  {
    i++;
  }
  XCopyArea( display, wmppxpIcon.pixmap, window, xgc,
             11, 36, 46, 5, 11, 36 );  
}

void CreateImageFromPixmap()
{
  XWindowAttributes attrIcon, attrParts;
  int error;

  XGetWindowAttributes( display, Root, &attrIcon );
  XGetWindowAttributes( display, Root, &attrParts );

  wmppxpIcon.attr.valuemask |= ( XpmReturnPixels | XpmReturnExtensions );
  wmppxpParts.attr.valuemask |= ( XpmReturnPixels | XpmReturnExtensions );

  error = XpmCreatePixmapFromData( display, Root, wmppxp_xpm,
                                   &(wmppxpIcon.pixmap),
                                   &(wmppxpIcon.mask),
                                   &(wmppxpIcon.attr) );

  if( error != XpmSuccess )
  {
    fprintf( stderr, "Can't allocate memory for colorcells\n" );
    exit( 1 );
  }

  error = XpmCreatePixmapFromData( display, Root, wmppxp_parts_xpm,
                                   &(wmppxpParts.pixmap),
                                   &(wmppxpParts.mask),
                                   &(wmppxpParts.attr) );
  if( error != XpmSuccess )
  {
    fprintf( stderr, "Can't allocate memory for colorcells\n" );
    exit( 1 );
  }

}

BOOL PtInButton( Rect rect, int x, int y )
{
  BOOL ret = FALSE;

  if( ( rect.left <= x && x <= rect.right ) &&
      ( rect.top <= y && y <= rect.bottom ) )
  {
    ret = TRUE;
  }

  return ret;
}

void ShowXpm( int sx, int sy, int sw, int sh, int dx, int dy )
{
  XCopyArea( display, wmppxpParts.pixmap, iconwin, xgc, sx, sy, sw, sh, dx, dy );
}

void ShowRunningTimeInArea( int timeDiff )
{
  int sec, min, hour;
  int num, numBy10;

  sec = timeDiff % 60;
  min = timeDiff / 60;
  hour = min / 60;
  min = min % 60;

  /* Show hour */
  num = hour % 10;
  numBy10 = hour / 10;
  ShowXpm( NUM_START_X + ( numBy10 * 6 ), NUM_START_Y, NUM_WIDTH, NUM_HEIGHT,
           13, 21 );
  ShowXpm( NUM_START_X + ( num * 6 ), NUM_START_Y, NUM_WIDTH, NUM_HEIGHT,
           19, 21 );

  /* Show minute */
  num = min % 10;
  numBy10 = min / 10;
  ShowXpm( NUM_START_X + ( numBy10 * 6 ), NUM_START_Y, NUM_WIDTH, NUM_HEIGHT,
           29, 21 );
  ShowXpm( NUM_START_X + ( num * 6 ), NUM_START_Y, NUM_WIDTH, NUM_HEIGHT,
           35, 21 );

  /* Show second */
  num = sec % 10;
  numBy10 = sec / 10;
  ShowXpm( NUM_START_X + ( numBy10 * 6 ), NUM_START_Y, NUM_WIDTH, NUM_HEIGHT,
           45, 21 );
  ShowXpm( NUM_START_X + ( num * 6 ), NUM_START_Y, NUM_WIDTH, NUM_HEIGHT,
           51, 21 );
}

void ShowBaudRate( unsigned int b_rate )
{
  int dev = 100000;
  unsigned int tmp = b_rate;
  int i;
  for( i=5; i>=0; i-- )
  {
    ShowXpm( NUM_START_X + ( 6 * ( tmp / dev ) ), NUM_START_Y,
             NUM_WIDTH, NUM_HEIGHT, 6 + ( 6 * ( -i + 5 ) ), 6 );

    tmp %= dev;    
    dev /= 10;
  }
}

void ShowRSBar( unsigned int b_rate, int in, int out )
{
  int inWidth, outWidth;
  inWidth = ( IO_BAR_WIDTH * ( in * 8 ) ) / b_rate;
  outWidth = ( IO_BAR_WIDTH * ( out * 8 ) ) / b_rate;
  if( inWidth == 0 && in != 0 )
  {
    /* If data flows but too small to display, set width 1 */
    inWidth = 1;
  }

  if( outWidth == 0 && out != 0 )
  {
    /* If data flows but too small to display, set width 1 */
    outWidth = 1;
  }

  if( inWidth > IO_BAR_WIDTH )
  {
    inWidth = IO_BAR_WIDTH;
  }
  if( outWidth > IO_BAR_WIDTH )
  {
    /* Barely happen? */
    outWidth = IO_BAR_WIDTH;
  }

  /* Show pixmap on input bar area */
  RedrawInMeter();
  ShowXpm( IO_BAR_X, IO_BAR_Y,
           ( ( inWidth <= IO_BAR_WIDTH ) ? inWidth : IO_BAR_WIDTH ),
           IO_BAR_HEIGHT,
           11, 30 );
  /* Show pixmap on output bar area */
  RedrawOutMeter();
  ShowXpm( IO_BAR_X, IO_BAR_Y,
           ( ( outWidth <= IO_BAR_WIDTH ) ? outWidth : IO_BAR_WIDTH ),
           IO_BAR_HEIGHT,
           11, 36 );
}
