#include "itemize.hh"
#include "trim_space.hh"
#include "clone_ptr-t.hh"
#include "container.hh"

namespace autil {

  class SplitListEmul : public VirEmulation<ListItem> {
    char * list;
    char * i;
    int size;
  public:
    SplitListEmul(const string & l) 
      : size (l.size() + 1)
    {
      list = new char[size];
      i = list;
      strncpy(list, l.c_str(), size);
    }
    ~SplitListEmul() 
    {
      delete[] list;
    }
    SplitListEmul(const SplitListEmul & other) 
      : size(other.size)
    {
      list = new char[size];
      i = list + (other.i - other.list);
      strncpy(list, other.list, size);
    }
    SplitListEmul & operator=(const SplitListEmul & other) 
    {
      if (this == &other) return *this;
      if (size != other.size) {
	delete[] list;
	size = other.size;
	list = new char[size];
      }
      i = list + (other.i - other.list);
      strncpy(list, other.list, size);
      return *this;
    }

    SplitListEmul * clone() const
    {
      return new SplitListEmul(*this);
    }
    void assign(const VirEmulation<ListItem> * other) 
    {
      *this = *static_cast<const SplitListEmul *>(other);
    }
    Value next() 
    {
      ListItem li;
      while (*i != '\0' && (isspace(*i) || *i == ',')) ++i;
      if (*i == '\0') return li;
      li.action = *i;
      if (*i == '+' || *i == '-') {
	++i;
      } else if (*i == '!') {
	li.name = "";
	++i;
	return li;
      } else {
	li.action = '+';
      }
      while (*i != '\0' && *i != ',' && isspace(*i)) ++i;
      if (*i == '\0' || *i == ',') return next();
      li.name = i;
      while (*i != '\0' && *i != ',') ++i;
      while (isspace(*(i-1))) --i;
      if (*i != '\0') {
	*i = '\0';
	++i;
      }
      return li;
    }
    bool at_end() const 
    {
      return *i == '\0';
    }
  };

  VirEmulation<ListItem> * split_list(const string & s) {
    return new SplitListEmul(s);
  }

  void itemize(const string & s, MutableContainer & d) {
    Emulation<ListItem> els = split_list(s);
    ListItem li;
    while (li = els.next(), li.name != 0) {
      switch (li.action) {
      case '+':
	d.insert(li.name);
	break;
      case '-':
	d.remove(li.name);
	break;
      case '!':
	d.clear();
	break;
      default:
	abort();
      }
    }
  }
}
