package tijmp.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import tijmp.ui.ClassInspector;
import tijmp.ui.Translator;
import tijmp.ui.ShowSimpleFrame;

/** An action that shows the class inspection dialog.
 */
public class InspectClass extends AbstractAction {
    private Class<?> clz;

    public InspectClass (Class<?> clz) {
	super ("Inspect class " + Translator.translate (clz));
	this.clz = clz;
    }

    public void actionPerformed (ActionEvent e) {
	ClassInspector ci = new ClassInspector (clz);
	String cn = Translator.translate (clz);
	new ShowSimpleFrame ().showFrame (cn + " info", ci);
    }    
}
