package org.apache.maven.doxia.sink;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import javax.swing.text.MutableAttributeSet;

/**
 * Empty implementation of the <code>Sink</code> interface. Useful for testing purposes.
 *
 * @since 1.0
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @author <a href="mailto:vincent.siveton@gmail.com">Vincent Siveton</a>
 * @version $Id: SinkAdapter.java 747837 2009-02-25 15:50:39Z ltheussl $
 */
public class SinkAdapter
    extends AbstractSink
{
    /** {@inheritDoc} */
    public void head()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void head_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void body()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void body_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section1()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section1_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section2()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section2_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section3()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section3_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section4()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section4_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section5()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section5_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void list()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void list_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void listItem()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void listItem_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedList( int numbering )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedList_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedListItem()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedListItem_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionList()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionList_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionListItem()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionListItem_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definition()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definition_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figure()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figure_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void table()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void table_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRows( int[] justification, boolean grid )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRows_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRow()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRow_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void title()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void title_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void author()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void author_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void date()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void date_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle1()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle1_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle2()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle2_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle3()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle3_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle4()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle4_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle5()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle5_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void paragraph()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void paragraph_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void verbatim( boolean boxed )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void verbatim_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definedTerm()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definedTerm_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figureCaption()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figureCaption_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCell()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCell( String width )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCell_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableHeaderCell()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableHeaderCell( String width )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableHeaderCell_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCaption()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCaption_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figureGraphics( String name )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void horizontalRule()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void pageBreak()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void anchor( String name )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void anchor_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void link( String name )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void link_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void italic()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void italic_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void bold()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void bold_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void monospaced()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void monospaced_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void lineBreak()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void nonBreakingSpace()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void text( String text )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void rawText( String text )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void comment( String comment )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void flush()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void close()
    {
        // nop
    }
    /** {@inheritDoc} */
    public void head( SinkEventAttributes attributes )
    {
        head();
    }

    /** {@inheritDoc} */
    public void title( SinkEventAttributes attributes )
    {
        title();
    }

    /** {@inheritDoc} */
    public void author( SinkEventAttributes attributes )
    {
        author();
    }

    /** {@inheritDoc} */
    public void date( SinkEventAttributes attributes )
    {
        date();
    }

    /** {@inheritDoc} */
    public void body( SinkEventAttributes attributes )
    {
        body();
    }

    /** {@inheritDoc} */
    public void section( int level, SinkEventAttributes attributes )
    {
        if ( level == SECTION_LEVEL_1 )
        {
            section1();
        }
        else if ( level == SECTION_LEVEL_2 )
        {
            section2();
        }
        else if ( level == SECTION_LEVEL_3 )
        {
            section3();
        }
        else if ( level == SECTION_LEVEL_4 )
        {
            section4();
        }
        else if ( level == SECTION_LEVEL_5 )
        {
            section5();
        }
    }

    /** {@inheritDoc} */
    public void section_( int level )
    {
        if ( level == SECTION_LEVEL_1 )
        {
            section1_();
        }
        else if ( level == SECTION_LEVEL_2 )
        {
            section2_();
        }
        else if ( level == SECTION_LEVEL_3 )
        {
            section3_();
        }
        else if ( level == SECTION_LEVEL_4 )
        {
            section4_();
        }
        else if ( level == SECTION_LEVEL_5 )
        {
            section5_();
        }
    }

    /** {@inheritDoc} */
    public void sectionTitle( int level, SinkEventAttributes attributes )
    {
        if ( level == SECTION_LEVEL_1 )
        {
            sectionTitle1();
        }
        else if ( level == SECTION_LEVEL_2 )
        {
            sectionTitle2();
        }
        else if ( level == SECTION_LEVEL_3 )
        {
            sectionTitle3();
        }
        else if ( level == SECTION_LEVEL_4 )
        {
            sectionTitle4();
        }
        else if ( level == SECTION_LEVEL_5 )
        {
            sectionTitle5();
        }
    }

    /** {@inheritDoc} */
    public void sectionTitle_( int level )
    {
        if ( level == SECTION_LEVEL_1 )
        {
            sectionTitle1_();
        }
        else if ( level == SECTION_LEVEL_2 )
        {
            sectionTitle2_();
        }
        else if ( level == SECTION_LEVEL_3 )
        {
            sectionTitle3_();
        }
        else if ( level == SECTION_LEVEL_4 )
        {
            sectionTitle4_();
        }
        else if ( level == SECTION_LEVEL_5 )
        {
            sectionTitle5_();
        }
    }

    /** {@inheritDoc} */
    public void list( SinkEventAttributes attributes )
    {
        list();
    }

    /** {@inheritDoc} */
    public void listItem( SinkEventAttributes attributes )
    {
        listItem();
    }

    /** {@inheritDoc} */
    public void numberedList( int numbering, SinkEventAttributes attributes )
    {
        numberedList( numbering );
    }

    /** {@inheritDoc} */
    public void numberedListItem( SinkEventAttributes attributes )
    {
        numberedListItem();
    }

    /** {@inheritDoc} */
    public void definitionList( SinkEventAttributes attributes )
    {
        definitionList();
    }

    /** {@inheritDoc} */
    public void definitionListItem( SinkEventAttributes attributes )
    {
        definitionListItem();
    }

    /** {@inheritDoc} */
    public void definition( SinkEventAttributes attributes )
    {
        definition();
    }

    /** {@inheritDoc} */
    public void definedTerm( SinkEventAttributes attributes )
    {
        definedTerm();
    }

    /** {@inheritDoc} */
    public void figure( SinkEventAttributes attributes )
    {
        figure();
    }

    /** {@inheritDoc} */
    public void figureCaption( SinkEventAttributes attributes )
    {
        figureCaption();
    }

    /** {@inheritDoc} */
    public void figureGraphics( String src, SinkEventAttributes attributes )
    {
        figureGraphics( src );
    }

    /** {@inheritDoc} */
    public void table( SinkEventAttributes attributes )
    {
        table();
    }

    /** {@inheritDoc} */
    public void tableRow( SinkEventAttributes attributes )
    {
        tableRow();
    }

    /** {@inheritDoc} */
    public void tableCell( SinkEventAttributes attributes )
    {
        tableCell();
    }

    /** {@inheritDoc} */
    public void tableHeaderCell( SinkEventAttributes attributes )
    {
        tableHeaderCell();
    }

    /** {@inheritDoc} */
    public void tableCaption( SinkEventAttributes attributes )
    {
        tableCaption();
    }

    /** {@inheritDoc} */
    public void paragraph( SinkEventAttributes attributes )
    {
        paragraph();
    }

    /** {@inheritDoc} */
    public void verbatim( SinkEventAttributes attributes )
    {
        MutableAttributeSet atts = SinkUtils.filterAttributes( attributes, SinkUtils.SINK_VERBATIM_ATTRIBUTES );

        boolean boxed = false;

        if ( atts != null && atts.isDefined( SinkEventAttributes.DECORATION ) )
        {
            boxed = "boxed".equals( atts.getAttribute( SinkEventAttributes.DECORATION ).toString() );
        }

        verbatim( boxed );
    }

    /** {@inheritDoc} */
    public void horizontalRule( SinkEventAttributes attributes )
    {
        horizontalRule();
    }

    /** {@inheritDoc} */
    public void anchor( String name, SinkEventAttributes attributes )
    {
        anchor( name );
    }

    /** {@inheritDoc} */
    public void link( String name, SinkEventAttributes attributes )
    {
        link( name );
    }

    /** {@inheritDoc} */
    public void lineBreak( SinkEventAttributes attributes )
    {
        lineBreak();
    }

    /** {@inheritDoc} */
    public void text( String text, SinkEventAttributes attributes )
    {
        text( text );
    }

    /** {@inheritDoc} */
    public void unknown( String name, Object[] requiredParams, SinkEventAttributes attributes )
    {
        // nop
    }
}
