
//
// $Id: str.h,v 1.2 2002/11/07 23:40:27 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/str.h,v $
// $Revision: 1.2 $
// $Date: 2002/11/07 23:40:27 $
// $State: Exp $
//
// Author: Geoff Wong
//
/*
 * String support routines (dynamic allocation etc)
 * Author: Geoff Wong
 */

#include <sys/types.h>
#include <regex.h>
#include <string.h>
#include "String.h"

char * string_copy(const char *);
    // allocate memory and copy a string

String itoa(int);
    // convert a number to a String

String itodot(int);
	// convert a number to dot notation.

String randomstr(int width);
    // return a String full of crap

int split(String, String *, int max, String sep);

int gsub(String& str, const String& pat, const String& repl);
	// global substitution of patterns found in a string

int reggsub(String& str, const String& regpat, const String& repl);

int regfind(const String& str, const String& pat);

string strip_whitespace(const string& str);

string strip_trailing_whitespace(const string& str);

string lowercase(const string& instr);

string topntail(const string& str);

