/*C* $Id: vga++.cc,v 1.3 1997/09/07 09:40:19 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "Console.h"
#include "Rect.h"
#include "Vga.h"
#include "palette.h"
#include "../util/debug.h"
#include "../util/error.h"
#include "../util/String.h"
#include "../util/util.h"
#include <assert.h>
#include <stdio.h>
#include <string.h>

#ifdef SVGALIB
#include <vga.h>
#endif

#ifdef GGI
#include <ggi/ggi.h>
#endif

//--------------------------------------------------------------------------------------------------------------------------------

Vga::Vga()
{
}

Vga::~Vga()
{
}

//--------------------------------------------------------------------------------------------------------------------------------

bool Vga::graphicsMode()
{
#ifdef SVGALIB
 String vmodeName = String("G") + String(vgaW) + String("x") + String(vgaH);
 switch(bpp)
  {
  case 8: vmodeName += "x256"; break;
  case 16: vmodeName += "x64K"; break;
  case 24: vmodeName += "x16M"; break;
  case 32: vmodeName += "x16M32"; break;
  }
 int vmodeNumber = vga_getmodenumber(const_cast<char*>(static_cast<const char*>(vmodeName))); // (char*) is svgalib being crap
 VPRINTF("<vga> Selected video mode: %s = %d\n", (const char*) vmodeName, vmodeNumber);
 // set the screen mode
 if(vga_setmode(vmodeNumber) != 0) { EPRINTF("Error setting videomode\n"); return false; }
#endif

#ifdef GGI
 switch(bpp)
  {
  case 8: if(ggiSetSimpleMode(consoleVisual, vgaW, vgaH, 1, GT_8BIT) < 0) return false; break;
  case 16: if(ggiSetSimpleMode(consoleVisual, vgaW, vgaH, 1, GT_16BIT) < 0) return false; break;
  case 24: if(ggiSetSimpleMode(consoleVisual, vgaW, vgaH, 1, GT_24BIT) < 0) return false; break;
  case 32: if(ggiSetSimpleMode(consoleVisual, vgaW, vgaH, 1, GT_32BIT) < 0) return false; break;
  }
#endif

 if(bpp == 8) setPalette();

 return true;
}

void Vga::textMode()
{
#ifdef SVGALIB
 vga_setmode(TEXT);
#endif
}

//--------------------------------------------------------------------------------------------------------------------------------

void Vga::update()
{
 for(int y = 0; y < vgaH; y++)
  {
#ifdef SVGALIB
   vga_drawscanline(y, fb()[y]);
#endif
#ifdef GGI
   ggiPutHLine(consoleVisual, 0, y, vgaW, fb()[y]);
#endif
  }
#ifdef GGI
 ggiFlush(consoleVisual);
#endif
}

void Vga::updateLineSegment(Point p, int w)
{
#ifdef SVGALIB
 vga_drawscansegment(&fb()[p.y][bypp * p.x], p.x, p.y, bypp * w);
#endif
#ifdef GGI
 ggiPutHLine(consoleVisual, p.x, p.y, w, &fb()[p.y][bypp * p.x]);
 ggiFlushRegion(consoleVisual, p.x, p.y, w, 1);
#endif
}

void Vga::update(Rect r)
{
 assert(r.onScreen());

#ifdef GGI
 for(int y = r.top(); y <= r.bottom(); y++)
  ggiPutHLine(consoleVisual, r.x, y, r.w, &fb()[y][bypp * r.x]);
 ggiFlushRegion(consoleVisual, r.x, r.y, r.w, r.h);
#endif

#ifdef SVGALIB
 for(int cy = r.top(); cy <= r.bottom(); cy++)
  updateLineSegment(Point(r.left(), cy), r.w);
#endif
}

//--------------------------------------------------------------------------------------------------------------------------------
