/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.unit;

public enum LengthUnit {
    
    INCH("in"), MILLIMETER("mm"), POINT("pt"), PICA("pc"), PIXEL("px"), EM("em"), CENTIMETER("cm"), PERCENT("%");
    
    private final String abbrev;

    private LengthUnit(String abbrev) {
        this.abbrev = abbrev;
    }

    public String getAbbreviation() {
        return abbrev;
    }
    
    public static LengthUnit valueOfAbbrev(String value) {
        
        if (value == null) {
            return null;
        }
        
        value = value.trim();
        
        if (value.equalsIgnoreCase("cm")) {
        	return CENTIMETER;
        }
        
        if (value.equalsIgnoreCase("em")) {
        	return EM;
        }
        
        if (value.equalsIgnoreCase("in")) {
            return INCH;
        }
        
        if (value.equalsIgnoreCase("mm")) {
            return MILLIMETER;
        }
        
        if (value.equalsIgnoreCase("pc")) {
        	return PICA;
        }
        
        if (value.equalsIgnoreCase("%")) {
        	return PERCENT;
        }

        if (value.equalsIgnoreCase("pt")) {
            return POINT;
        }
        
        return null;
    }
}
