<?php
/**
 * Kolab XML handler for event groupware objects
 *
 * $Horde: framework/Kolab/Kolab/XML/event.php,v 1.2.2.3 2008/03/11 17:02:58 wrobel Exp $
 *
 * Copyright 2007-2008 The Horde Project (http://www.horde.org/)
 *
 * @author  Thomas Jarosch <thomas.jarosch@intra2net.com>
 * @author  Gunnar Wrobel <wrobel@pardus.de>
 * @package Horde_Kolab
 */

/** Kolab date handling functions. */
require_once 'Horde/Kolab/Date.php';

class Horde_Kolab_XML_event extends Horde_Kolab_XML {
    /**
     * Specific data fields for the contact object
     *
     * @var array
     */
    var $_fields_specific;

    /**
     * Constructor
     */
    function Horde_Kolab_XML_event()
    {
        $this->_root_name = 'event';

        /** Specific event fields, in kolab format specification order
         */
        $this->_fields_specific = array(
            'summary' => array (
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'location' => array (
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'organizer' => $this->_fields_simple_person,
            'start-date' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_NOT_EMPTY,
            ),
            'alarm' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_INTEGER,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'recurrence' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_COMPOSITE,
                'value'   => HORDE_KOLAB_XML_VALUE_CALCULATED,
                'load'    => 'Recurrence',
                'save'    => 'Recurrence',
            ),
            'attendee' => $this->_fields_attendee,
            'show-time-as' => array (
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'color-label' => array (
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'end-date' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_NOT_EMPTY,
            ),
        );

        parent::Horde_Kolab_XML();
    }

    /**
     * Load event XML values and translate start/end date
     *
     * @param array $children An array of XML nodes
     *
     * @return array Array with data or PEAR error
     */
    function _load(&$children)
    {
        $object = parent::_load($children);
        if (is_a($object, 'PEAR_Error')) {
            return $object;
        }

        // Translate start/end date including full day events
        if (strlen($object['start-date']) == 10) {
            $object['start-date'] = Kolab_Date::decodeDate($object['start-date']);
            $object['end-date'] = Kolab_Date::decodeDate($object['end-date']) + 24*60*60;
        } else {
            $object['start-date'] = Kolab_Date::decodeDateTime($object['start-date']);
            $object['end-date'] = Kolab_Date::decodeDateTime($object['end-date']);
        }

        return $object;
    }

    /**
     * Save event XML values and translate start/end date
     *
     * @param array $root     The XML document root
     * @param array $object   The resulting data array
     *
     * @return boolean True on success, a PEAR error otherwise
     */
    function _save($root, $object)
    {
        // Translate start/end date including full day events
        if (!empty($object['_is_all_day'])) {
            $object['start-date'] = Kolab_Date::encodeDate($object['start-date']);
            $object['end-date'] = Kolab_Date::encodeDate($object['end-date'] - 24*60*60);
        } else {
            $object['start-date'] = Kolab_Date::encodeDateTime($object['start-date']);
            $object['end-date'] = Kolab_Date::encodeDateTime($object['end-date']);
        }

        return parent::_save($root, $object);
    }
}
