--  Haskell Binding for dl{open,sym,...}          -*-haskell-*-
--
--  Author : Volker Stolz <stolz@i2.informatik.rwth-aachen.de>
--
--  Created: 2001-11-22
--
--  Derived from GModule.chs by M.Weber & M.Chakravarty which is part of c2hs
--  I left the API more or less the same, mostly the flags are different.
--
--  License: BSD
--

module DLPrim
  {-# DEPRECATED "Use System.Posix.DynamicLinker.Prim instead" #-}
  (
  dlopen,
  dlsym,
  dlerror,
  dlclose,
  -- dlAddr, -- XXX NYI
  haveRtldNext,
  haveRtldLocal,
  packModuleFlags,
  ModuleFlags(..),
  Source(..)
 )

where

import Data.Bits	( (.|.) )
import Foreign.Ptr	( Ptr, FunPtr )
import Foreign.C.Types	( CInt )
import Foreign.C.String	( CString )
import System.Posix.DynamicLinker.Prim ( haveRtldNext, haveRtldLocal )

#include <dlfcn.h>

-- data type definition
-- --------------------

-- flags passed to `moduleOpen' (EXPORTED)
--
data ModuleFlags 
  = RTLD_LAZY
  | RTLD_NOW
  | RTLD_GLOBAL 
  | RTLD_LOCAL
    deriving (Show, Read)

foreign import ccall unsafe "dlopen" dlopen :: CString -> CInt -> IO (Ptr ())
foreign import ccall unsafe "dlsym"  dlsym  :: (Ptr ()) -> CString -> IO (FunPtr a)
foreign import ccall unsafe "dlerror" dlerror :: IO CString
foreign import ccall unsafe "dlclose" dlclose :: (Ptr ()) -> IO ()

packModuleFlags :: [ModuleFlags] -> CInt
packModuleFlags flags = foldl (\ s f -> (packOneModuleFlag f) .|. s) 0 flags

packOneModuleFlag :: ModuleFlags -> CInt
packOneModuleFlag RTLD_LAZY = #const RTLD_LAZY

#ifdef HAVE_RTLDNOW
packOneModuleFlag RTLD_NOW = #const RTLD_NOW
#else /* HAVE_RTLDNOW */
packOneModuleFlag RTLD_NOW =  error "RTLD_NOW not available"
#endif /* HAVE_RTLDNOW */

#ifdef HAVE_RTLDGLOBAL
packOneModuleFlag RTLD_GLOBAL = #const RTLD_GLOBAL
#else /* HAVE_RTLDGLOBAL */
packOneModuleFlag RTLD_GLOBAL = error "RTLD_GLOBAL not available"
#endif

#ifdef HAVE_RTLDLOCAL
packOneModuleFlag RTLD_LOCAL = #const RTLD_LOCAL
#else /* HAVE_RTLDLOCAL */
packOneModuleFlag RTLD_LOCAL = error "RTLD_LOCAL not available"
#endif /* HAVE_RTLDLOCAL */

data Source = Null | Next | Default | Name CString
